<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'minimum', 'delivery', 'image', 'neighborhood_id', 'api_token', 'whats_app', 'restaurant_phone', 'pin_code');

    public function categories()
    {
        return $this->belongsToMany('App\Model\Category');
    }

    public function neighborhood()
    {
        return $this->belongsTo('App\Model\Neighborhood');
    }

    public function products()
    {
        return $this->hasMany('App\Model\Product');
    }

    public function offers()
    {
        return $this->hasMany('App\Model\Offer');
    }

    public function comments()
    {
        return $this->hasMany('App\Model\Comment');
    }

    public function payments()
    {
        return $this->hasMany('App\Model\Payment');
    }

    public function notifications()
    {
        return $this->morphMany('App\Model\Notification', '"notifiiable"');
    }

    public function tokens()
    {
        return $this->morphMany('App\Model\Token', '"tokenable"');
    }

    public function orders()
    {
        return $this->hasMany('App\Model\Order');
    }

}